(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     35378,       1264]*)
(*NotebookOutlinePosition[     50748,       1667]*)
(*  CellTagsIndexPosition[     49566,       1632]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["New", "Command",
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["New", "SR"],
  " creates a new notebook."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] The notebook is initially empty. When you start \
typing, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"ExtraLight"],
  "creates a cell to hold what you type."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"New"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["n", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"New"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Open...", "Command",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open", "SR"],
  " brings up a dialog box to open an existing notebook."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData["\[FilledSmallSquare] To open a notebook:"], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "1.  Choose ",
  StyleBox["Open", "SR"],
  " from the File menu.\n2.  In the list box that appears, look for the file \
you want to open. \n3.  Click the name of the file, then click the Open \
button or double-click the name of the file."
}], "ItemizedText",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] By default, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " shows only the files that it knows exactly how to open."
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Open Special",
    ButtonStyle->"OtherInformationLink"],
  " for how to open other file types."
}], "Notes",
  CellTags->"Open"],

Cell[TextData[{
  "\[FilledSmallSquare] When you try to open a pre-3.0 Version notebook, you \
can convert the notebook into a Version 3.0 format. Several conversion \
options are available. \n    ",
  StyleBox["Important",
    FontWeight->"Bold"],
  ": Check that you have write permission in the directory where you are \
converting the notebooks. Otherwise ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will not be able to convert the files."
}], "Notes",
  CellTags->{"convertingFrom22NotebookDialogID", "Open"}],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["o", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " understands the following file types:"
}], "Subsubsection",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] TEXT",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["\<\
Files in plain text  from any word processor are opened with all the text in \
a single active initialization cell. When all the text appears on one line, \
you may want to switch the cell's style to \"Text\" style, which is normally \
a word-wrapping style.\
\>", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "See: ",
  ButtonBox["Open Special",
    ButtonStyle->"OtherInformationLink"],
  " for how to open a text file putting lines or paragraphs in separate \
cells. "
}], "NotesList"],

Cell[TextData[StyleBox["\[FilledSmallSquare] Scrapbook (Macintosh)",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["\<\
Files from the Scrapbook open as notebooks containing all the PICT, TEXT, and \
SND (sound) objects in the scrap file. Note that you can't save the resulting \
file in Scrapbook form.\
\>", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] PICT (Macintosh)",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["\<\
Files from most graphics programs saved in PICT format open as a single cell \
containing the picture in the file.\
\>", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] EPSF",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[{
  "Encapsulated PostScript files open as notebooks containing a single \
graphics cell. For a file originally produced by ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ", the resulting cell is identical to the one that produced the file. For a \
file produced by another program, the PostScript may require some manual \
editing before it can be rendered or printed."
}], "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell[TextData[StyleBox["\[FilledSmallSquare] QuickTime (Macintosh)",
  FontWeight->"Bold"]], "Notes",
  AspectRatioFixed->False,
  CellTags->"Open"],

Cell["QuickTime movies are opened as a  QuickTime cell.", "NotesList",
  AspectRatioFixed->False,
  CellTags->"Open"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Close",
  FontWeight->"Bold"]], "Command",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Close", "SR"],
  " closes the currently selected notebook."
}], "Usage",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] When you close notebook windows, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  asks if you want to save any changes made since your previous save."
}], "Notes",
  CellTags->"Close"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["F4", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["w", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]", "C1"],
  StyleBox["\[LeftModified]", "C1"],
  StyleBox["w", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Close"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Save",
  FontWeight->"Bold"]], "Command",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save", "SR"],
  " writes out the currently selected notebook. "
}], "Usage",
  CellTags->"Save"],

Cell[TextData[{
  "\[FilledSmallSquare] Use ",
  StyleBox["Save", "SR"],
  " to record changes made to a notebook already stored on disk. If the \
current notebook is still untitled (not yet saved on disk), ",
  StyleBox["Save", "SR"],
  " behaves exactly like ",
  StyleBox["Save As", "SR"],
  " and asks you to name it. "
}], "Notes",
  CellTags->"Save"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["s", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["s", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]", "C1"],
  StyleBox["\[LeftModified]", "C1"],
  StyleBox["s", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"Save"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Save As...",
  FontWeight->"Bold"]], "Command",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save As", "SR"],
  " writes out the notebook in a file with a new name."
}], "Usage",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] To save a notebook in a different file format, use ",
  StyleBox["Save As Special", "SR"],
  ". "
}], "Notes",
  CellTags->"SaveRename"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["S", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["S", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]", "C1"],
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["S", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"SaveRename"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Save As Special...",
  FontWeight->"Bold"]], "Command",
  CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Save As Special", "SR"],
  " writes out the notebook in the specified format."
}], "Usage",
  CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3.0 notebook files contain ",
  StyleBox["Notebook", "MR"],
  " expressions written in textual form. ",
  StyleBox["Save As Special", "SR"],
  " converts the notebook to other forms. "
}], "Notes",
  CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Pre-3.0 Notebook",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Pre-3.0 Notebook", "SR"],
  " converts the notebook to a form that can be opened by older versions of \
the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Text",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialText"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Text", "SR"],
  " writes out the contents of a notebook in plain text. "
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialText"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["CellExpression",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialCellExpression"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] CellExpression", "SR"],
  " writes out one or more cell objects, but does not write out the notebook \
options, style sheet references, etc."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialCellExpression"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["NotebookExpression",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialNotebookExpression"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] NotebookExpression", "SR"],
  " writes out the full notebook expression without the extra cache \
information usually contained in a notebook file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialNotebookExpression"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Package Format",
  FontWeight->"Bold"]], "Command",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialPackage"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] Package Format", "SR"],
  " saves the text of the file in the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " package, commenting out all cells except initialization cells. "
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"SaveRenameSpecialPackage"],

Cell[TextData[{
  "\[FilledSmallSquare] See: ",
  ButtonBox["Initialization",
    ButtonStyle->"OtherInformationLink"],
  "."
}], "Notes",
  CellTags->"SaveRenameSpecialPackage"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TeX", "Command",
  AspectRatioFixed->False,
  CellTags->"TeXSave"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] TeX", "SR"],
  " converts the notebook to TeX and writes it out to a file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"TeXSave"]
}, Open  ]],

Cell[TextData[
"\[FilledSmallSquare] This command requires a local kernel."], "Notes",
  AspectRatioFixed->False,
  CellTags->"TeXSave"],

Cell[CellGroupData[{

Cell["HTML", "Command",
  AspectRatioFixed->False,
  CellTags->"HTMLSave"],

Cell[TextData[{
  StyleBox["\[FilledSmallSquare] HTML", "SR"],
  " converts the notebook to HTML and writes it out to a file."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"HTMLSave"]
}, Open  ]]
}, Open  ]],

Cell[TextData[
"\[FilledSmallSquare] This command requires a local kernel."], "Notes",
  AspectRatioFixed->False,
  CellTags->"HTMLSave"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Open Special...",
  FontWeight->"Bold"]], "Command",
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open Special", "SR"],
  " opens files other than ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  notebooks, or notebooks modified outside ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Usage",
  CellTags->"OpenSpecial"],

Cell[TextData[
"\[FilledSmallSquare] The dialog box lists the following choices for how the \
file will be interpreted."], "Text",
  CellTags->"OpenSpecial"],

Cell["File reading method", "Subsubsection",
  AspectRatioFixed->False,
  CellTags->"OpenSpecial"],

Cell[TextData[StyleBox["Ignore File Outline Cache",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"OpenSpecial"],

Cell["\<\
Opens a notebook without reading the cached outline of the notebook. If your \
notebook has been corrupted, this can be a way to recover it. The outline \
cache increases the speed of opening a  notebook.\
\>", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["All In One Cell", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Puts the entire file in one cell.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["New Cell At Every Line", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Puts every line of the file into a separate cell.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["New Cell At Every Blank Line", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Breaks the file into cells at every blank line.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["New Cell At Every Two Blank Lines", "DialogItem",
  CellTags->"OpenSpecial"],

Cell["Breaks the file into cells at every two blank lines.", "IndentedText",
  CellTags->"OpenSpecial"],

Cell[TextData[StyleBox["Extract Resources",
  FontWeight->"Bold"]], "DialogItem",
  CellTags->"OpenSpecial"],

Cell["\<\
Extracts only the Macintosh resources of the file (PICT, TEXT, sound, etc.), \
ignoring the rest. This can be used to get information out of certain types \
of files that ordinarily cannot be opened. Note that you can open the \
Scrapbook, PICT, and EPSF files directly without using this option.\
\>", "IndentedText",
  CellTags->"OpenSpecial"],

Cell["Character encoding", "Subsubsection",
  AspectRatioFixed->False,
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] Uses the specified character encoding standard to \
determine how raw characters in the file are translated. The pop-up menu \
lists the character encoding files currently available to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["$SystemCharacterEncoding", "Input",
    FontWeight->"Bold"],
  " uses the standard character encoding for your computer  system."
}], "Notes",
  CellTags->"OpenSpecial"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 2.7.7",
    ButtonData:>{"2.7.7"},
    ButtonStyle->"MainBookLink"],
  ",  ",
  ButtonBox["Section 2.7.8",
    ButtonData:>{"2.7.8"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"OpenSpecial"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Open Selection",
  FontWeight->"Bold"]], "Command",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Open Selection", "SR"],
  " opens a notebook whose name is given by the current selection."
}], "Usage",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "If no path name is given, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " will look for the notebook in the current directory (",
  StyleBox["i.e.",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  ", the directory containing the current notebook). "
}], "Notes",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  "On a Macintosh, absolute path names begin with the name of the device (",
  StyleBox["e.g",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[".",
    FontWeight->"ExtraLight"],
  ", a hard drive), and are separated by colons (",
  StyleBox["device",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"ExtraLight"],
  ": ",
  StyleBox["folder",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"ExtraLight"],
  ": ",
  StyleBox["folder",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " : ",
  StyleBox["notebook",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " )."
}], "Notes",
  CellTags->"OpenSelection"],

Cell[TextData[{
  "\[FilledSmallSquare] If you use a relative path name, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " will find notebooks contained in directories of the current directory."
}], "Notes",
  CellTags->"OpenSelection"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Import",
  FontWeight->"Bold"]], "Command",
  CellTags->"Import"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Import", "SR"],
  " opens a notebook and inserts its contents into a cell in the current \
notebook. "
}], "Usage",
  CellTags->"Import"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Palettes",
  FontWeight->"Bold"]], "Command",
  CellTags->"MenuListPalettesMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Palettes", "SR"],
  " lists currently available palettes."
}], "Usage",
  CellTags->"MenuListPalettesMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] Palette files are kept in \
SystemFiles/FrontEnd/Palettes. Palette files added to this subdirectory will \
be listed in the menu when you restart ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"MenuListPalettesMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] See the ",
  StyleBox["Mathematica", "TI"],
  " book:  ",
  ButtonBox["Section 1.3.6",
    ButtonData:>{"1.3.6"},
    ButtonStyle->"MainBookLink"],
  "."
}], "Notes",
  CellTags->"MenuListPalettesMenu"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Notebooks",
  FontWeight->"Bold"]], "Command",
  CellTags->"MenuListNotebooksMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Notebooks", "SR"],
  " lists recently opened notebooks."
}], "Usage",
  CellTags->"MenuListNotebooksMenu"],

Cell[TextData[{
  "\[FilledSmallSquare] The ",
  StyleBox["Modify This Menu", "SR"],
  " dialog box lets you add or delete notebooks from the list in the ",
  StyleBox["Notebooks", "MR"],
  " menu."
}], "Notes",
  CellTags->{"MenuListNotebooksMenu", "ModifyNotebooksMenu"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Generate Palette from Selection",
  FontWeight->"Bold"]], "Command",
  CellTags->"GeneratePalette"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Generate Palette from Selection", "SR"],
  " converts the selected notebook into a palette."
}], "Usage",
  CellTags->"GeneratePalette"],

Cell[TextData[{
  "\[FilledSmallSquare] The palette is opened in a separate window. Choose ",
  StyleBox["Save", "SR"],
  " to save the palette and give it a file name."
}], "Notes",
  CellTags->"GeneratePalette"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Generate Notebook from Palette",
  FontWeight->"Bold"]], "Command",
  CellTags->"GenerateNotebook"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Generate Notebook  from Palette", "SR"],
  " converts the selected palette into an ordinary notebook."
}], "Usage",
  CellTags->"GenerateNotebook"]
}, Open  ]],

Cell["Printing Settings", "Command"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Page Setup...",
  FontWeight->"Bold"]], "Command",
  CellTags->"SystemPrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Page Setup", "SR"],
  " controls the size and shape of the pages to be printed. The options \
available vary with the particular printer being used."
}], "Usage",
  CellTags->"SystemPrintOptionsDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Printing Options...",
  FontWeight->"Bold"]], "Command",
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Printing Options", "SR"],
  " sets options for printing a notebook. ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  saves your new settings with the notebook, so it will be printed the \
same way in the future."
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Print cell brackets",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell["When checked, the cell grouping brackets are printed.", "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Print registration marks",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "When checked, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " prints guide marks bounding the printed area of the page. This option is \
useful in conjunction with the \"Print multiple pages for wide cells\" \
option. The registration marks can be used to line up separate pages to make \
a large poster."
}], "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Print multiple pages for wide cells",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[{
  "When checked, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  prints as many pages as needed to show wide cells (for example, very \
wide graphics cells). "
}], "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell[TextData[StyleBox["Margins",
  FontWeight->"Bold"]], "DialogItem",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"],

Cell["\<\
Determines how much white space will be left on the page after printing. Text \
that is set to word-wrap will wrap to the printing margin width, not the \
window width. \
\>", "IndentedText",
  AspectRatioFixed->False,
  CellTags->"PrintOptionsDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Headers and Footers...",
  FontWeight->"Bold"]], "Command",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Headers and Footers", "SR"],
  " sets options for printing a notebook. "
}], "Usage",
  AspectRatioFixed->False,
  CellTags->"HeadersFootersDialog"]
}, Open  ]],

Cell[TextData[
"\[FilledSmallSquare] When you open this dialog box and click OK, printouts \
of the current notebook will have headers and footers added according to the \
specified settings."], "Notes",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  saves your new settings with the notebook, so it will be printed the \
same way in the future."
}], "Notes",
  CellTags->"HeadersFootersDialog"],

Cell["Starting page number ", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["Sets the number for the first page of the notebook. ", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["No header on first page", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["When checked, the first page is printed without a header.", 
  "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["No footer on first page", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["When checked, the first page is printed without a footer.", 
  "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Left and right pages", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
When unchecked, all pages use the Right page header and footer.
When checked, the settings for Left and Right are used alternately. This \
typically means that  the arrangement of header and footer elements is \
inverted for facing pages. For example, page numbers are placed flush \
outside, left on left-hand pages, right on right-hand pages. 
This option is typically used when a document is printed double-sided.\
\>", 
  "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["First page on Left/Right", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Specifies whether the Left or Right header and footer are used on \
the first page.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Left page header
Right page header
Left page footer
Right page footer\
\>", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
These radio buttons determine which text fields are displayed \
below.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Left aligned text box", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Information entered here is printed against the left page margin of the \
specified header or footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Centered:", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Information entered here is printed in the center of the specified header or \
footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Right aligned text box:", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
Information entered here is printed against the right page margin of the \
specified header or footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell["Include Line", "DialogItem",
  CellTags->"HeadersFootersDialog"],

Cell["\<\
When checked, a rule is printed below each the selected header or \
above the selected footer.\
\>", "IndentedText",
  CellTags->"HeadersFootersDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["The text displayed in these fields is typically a ", "Text"],
  StyleBox["Cell[]", "MR"],
  StyleBox[" expression.  You can use the ", "Text"],
  StyleBox["Show Expression", "SR"],
  StyleBox[
  " menu command to see the expression corresponding to a cell in a Notebook. \
 Following are some useful ", "Text"],
  StyleBox["Cell[]", "MR"],
  StyleBox[" expressions to use as headers or footers:", "Text"],
  "\n   ",
  StyleBox["Cell[TextData[{CounterBox[ \"Page\"]}], \"PageNumber\"] ", "MR"],
  "defines a cell with  the Automatic Numbering object \"",
  StyleBox["Page", "MR"],
  "\" using the cell style \"",
  StyleBox["PageNumber", "MR"],
  "\". ",
  StyleBox["CounterBox[", "MR"],
  "\"",
  StyleBox["Page", "MR"],
  "\"] is replaced with the appropriate page number and is  incremented for \
each printed page.\n   ",
  StyleBox[
  "Cell[TextData[{OptionValueBox[\"FileName\"]}], \"Header\"] ", "MR"],
  "  inserts the Value Display Object ",
  StyleBox["\"FileName\"", "MR"],
  " using the cell style ",
  StyleBox["\"Header\"", "MR"],
  ".  ",
  StyleBox["OptionValueBox[\"FileName\"]", "MR"],
  " is replaced with the notebook's filename,  which is a string. This object \
can be replaced by an arbitrary string.\n"
}], "Notes",
  CellTags->"HeadersFootersDialog"],

Cell[CellGroupData[{

Cell["Print...", "Command",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Print", "SR"],
  " prints the active notebook."
}], "Usage",
  CellTags->"PrintDialog"],

Cell[TextData[
"\[FilledSmallSquare] The options available vary with the particular printer \
being used."], "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] The page size and shape must first be specified using \
",
  StyleBox["Page Setup", "SR"],
  ". Various other options can be set using ",
  StyleBox["Printing Options", "SR"],
  StyleBox[".",
    FontWeight->"Bold"]
}], "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[
"\[FilledSmallSquare] Contents of closed cells and closed groups are not \
printed."], "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Note that printed notebooks use the style settings \
for the ",
  StyleBox["Printing Style Environment",
    FontWeight->"Bold"],
  " (Format Menu), which can be significantly different from the styles \
chosen for on-screen display."
}], "Notes",
  CellTags->"PrintDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]", "C1"],
  StyleBox["\[LeftModified]", "C1"],
  StyleBox["p", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"PrintDialog"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Print Selection...", "Command",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Print Selection", "SR"],
  " prints the current selection within a notebook."
}], "Usage",
  CellTags->"PrintSelectionDialog"],

Cell[TextData[{
  "\[FilledSmallSquare] You can print any cell selection.If you have selected \
part of a single cell, ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  "  prints the whole cell."
}], "Notes",
  CellTags->"PrintSelectionDialog"]
}, Open  ]],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:  ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[KeyBar]\[ControlKey]\[LeftModified]", "C1"],
  StyleBox["P", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["P", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[ShiftKey]", "C1MR"],
  StyleBox["\[KeyBar]\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["P", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"PrintSelectionDialog"],

Cell[CellGroupData[{

Cell["Quit", "Command",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Quit", "SR"],
  " exits from ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  StyleBox[".",
    FontWeight->"ExtraLight"]
}], "Usage",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontWeight->"ExtraLight",
    FontSlant->"Italic"],
  " asks if you want to save any unsaved notebooks before quitting, since \
changes would otherwise be lost."
}], "Notes",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] Any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernels you have running are killed when you quit the front end."
}], "Notes",
  CellTags->"FrontEndQuit"],

Cell[TextData[{
  "\[FilledSmallSquare] Keyboard shortcuts:   ",
  StyleBox["\[AltKey]\[KeyBar][", "C1"],
  StyleBox["F4", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Windows)", "Notes"],
  "; ",
  StyleBox["\[CommandKey]\[LeftModified]", "C1"],
  StyleBox["q", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(Macintosh, NeXT); ", "Notes"],
  " ",
  StyleBox["\[Mod1Key]\[LeftModified]", "C1"],
  StyleBox["q", "C1MR"],
  StyleBox["\[RightModified] ", "C1"],
  StyleBox["(X).", "Notes"]
}], "Notes",
  AspectRatioFixed->False,
  CellTags->"FrontEndQuit"]
}, Open  ]]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{488, 398},
WindowMargins->{{10, Automatic}, {Automatic, 5}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrintingOptions->{"PrintingMargins"->{{Inherited, 88}, {Inherited, 
Inherited}}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "New"->{
    Cell[1731, 51, 41, 1, 34, "Command",
      CellTags->"New"],
    Cell[1775, 54, 155, 6, 29, "Usage",
      CellTags->"New"],
    Cell[1933, 62, 330, 11, 36, "Notes",
      CellTags->"New"],
    Cell[2266, 75, 582, 18, 22, "Notes",
      CellTags->"New"]},
  "Open"->{
    Cell[2885, 98, 73, 2, 34, "Command",
      CellTags->"Open"],
    Cell[2961, 102, 186, 6, 29, "Usage",
      CellTags->"Open"],
    Cell[3150, 110, 114, 2, 22, "Notes",
      CellTags->"Open"],
    Cell[3267, 114, 324, 8, 80, "ItemizedText",
      CellTags->"Open"],
    Cell[3594, 124, 257, 8, 22, "Notes",
      CellTags->"Open"],
    Cell[3854, 134, 189, 6, 22, "Notes",
      CellTags->"Open"],
    Cell[4046, 142, 529, 12, 70, "Notes",
      CellTags->{"convertingFrom22NotebookDialogID", "Open"}],
    Cell[4578, 156, 583, 18, 22, "Notes",
      CellTags->"Open"],
    Cell[5186, 178, 178, 6, 32, "Subsubsection",
      CellTags->"Open"],
    Cell[5367, 186, 131, 3, 22, "Notes",
      CellTags->"Open"],
    Cell[5501, 191, 334, 7, 52, "NotesList",
      CellTags->"Open"],
    Cell[6037, 208, 148, 3, 22, "Notes",
      CellTags->"Open"],
    Cell[6188, 213, 259, 6, 52, "NotesList",
      CellTags->"Open"],
    Cell[6450, 221, 143, 3, 22, "Notes",
      CellTags->"Open"],
    Cell[6596, 226, 190, 5, 38, "NotesList",
      CellTags->"Open"],
    Cell[6789, 233, 131, 3, 22, "Notes",
      CellTags->"Open"],
    Cell[6923, 238, 488, 11, 66, "NotesList",
      CellTags->"Open"],
    Cell[7414, 251, 148, 3, 22, "Notes",
      CellTags->"Open"],
    Cell[7565, 256, 117, 2, 24, "NotesList",
      CellTags->"Open"]},
  "convertingFrom22NotebookDialogID"->{
    Cell[4046, 142, 529, 12, 70, "Notes",
      CellTags->{"convertingFrom22NotebookDialogID", "Open"}]},
  "Close"->{
    Cell[7731, 264, 87, 2, 34, "Command",
      CellTags->"Close"],
    Cell[7821, 268, 148, 5, 29, "Usage",
      CellTags->"Close"],
    Cell[7972, 275, 265, 7, 36, "Notes",
      CellTags->"Close"],
    Cell[8240, 284, 607, 19, 22, "Notes",
      CellTags->"Close"]},
  "Save"->{
    Cell[8884, 308, 85, 2, 34, "Command",
      CellTags->"Save"],
    Cell[8972, 312, 151, 5, 29, "Usage",
      CellTags->"Save"],
    Cell[9126, 319, 356, 10, 50, "Notes",
      CellTags->"Save"],
    Cell[9497, 332, 605, 19, 22, "Notes",
      CellTags->"Save"]},
  "SaveRename"->{
    Cell[10127, 355, 97, 2, 34, "Command",
      CellTags->"SaveRename"],
    Cell[10227, 359, 166, 5, 29, "Usage",
      CellTags->"SaveRename"],
    Cell[10396, 366, 176, 5, 22, "Notes",
      CellTags->"SaveRename"],
    Cell[10575, 373, 743, 22, 22, "Notes",
      CellTags->"SaveRename"]},
  "SaveRenameSpecial"->{
    Cell[11355, 400, 139, 2, 34, "Command",
      CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],
    Cell[11497, 404, 206, 5, 29, "Usage",
      CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],
    Cell[11706, 411, 364, 10, 36, "Notes",
      CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}]},
  "SaveRenameSpecialNeXT"->{
    Cell[11355, 400, 139, 2, 34, "Command",
      CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],
    Cell[11497, 404, 206, 5, 29, "Usage",
      CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],
    Cell[11706, 411, 364, 10, 36, "Notes",
      CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}]},
  "SaveRenameSpecialV20Notebook"->{
    Cell[12095, 425, 187, 4, 34, "Command",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],
    Cell[12285, 431, 356, 11, 43, "Usage",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]},
  "convertingTo22NotebookDialogID"->{
    Cell[12095, 425, 187, 4, 34, "Command",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],
    Cell[12285, 431, 356, 11, 43, "Usage",
      CellTags->{
      "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]},
  "SaveRenameSpecialText"->{
    Cell[12678, 447, 129, 3, 34, "Command",
      CellTags->"SaveRenameSpecialText"],
    Cell[12810, 452, 204, 6, 29, "Usage",
      CellTags->"SaveRenameSpecialText"]},
  "SaveRenameSpecialCellExpression"->{
    Cell[13051, 463, 149, 3, 34, "Command",
      CellTags->"SaveRenameSpecialCellExpression"],
    Cell[13203, 468, 277, 6, 43, "Usage",
      CellTags->"SaveRenameSpecialCellExpression"]},
  "SaveRenameSpecialNotebookExpression"->{
    Cell[13517, 479, 157, 3, 34, "Command",
      CellTags->"SaveRenameSpecialNotebookExpression"],
    Cell[13677, 484, 288, 6, 43, "Usage",
      CellTags->"SaveRenameSpecialNotebookExpression"]},
  "SaveRenameSpecialPackage"->{
    Cell[14002, 495, 142, 3, 34, "Command",
      CellTags->"SaveRenameSpecialPackage"],
    Cell[14147, 500, 324, 8, 43, "Usage",
      CellTags->"SaveRenameSpecialPackage"],
    Cell[14474, 510, 178, 6, 22, "Notes",
      CellTags->"SaveRenameSpecialPackage"]},
  "TeXSave"->{
    Cell[14689, 521, 72, 2, 34, "Command",
      CellTags->"TeXSave"],
    Cell[14764, 525, 187, 5, 29, "Usage",
      CellTags->"TeXSave"],
    Cell[14966, 533, 136, 3, 22, "Notes",
      CellTags->"TeXSave"]},
  "HTMLSave"->{
    Cell[15127, 540, 74, 2, 34, "Command",
      CellTags->"HTMLSave"],
    Cell[15204, 544, 190, 5, 29, "Usage",
      CellTags->"HTMLSave"],
    Cell[15421, 553, 137, 3, 22, "Notes",
      CellTags->"HTMLSave"]},
  "OpenSpecial"->{
    Cell[15583, 560, 103, 2, 34, "Command",
      CellTags->"OpenSpecial"],
    Cell[15689, 564, 335, 12, 43, "Usage",
      CellTags->"OpenSpecial"],
    Cell[16027, 578, 157, 3, 22, "Text",
      CellTags->"OpenSpecial"],
    Cell[16187, 583, 98, 2, 32, "Subsubsection",
      CellTags->"OpenSpecial"],
    Cell[16288, 587, 116, 2, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[16407, 591, 263, 5, 48, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[16673, 598, 64, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[16740, 601, 84, 1, 20, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[16827, 604, 71, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[16901, 607, 100, 1, 20, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[17004, 610, 77, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[17084, 613, 98, 1, 20, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[17185, 616, 82, 1, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[17270, 619, 103, 1, 20, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[17376, 622, 108, 2, 25, "DialogItem",
      CellTags->"OpenSpecial"],
    Cell[17487, 626, 355, 6, 62, "IndentedText",
      CellTags->"OpenSpecial"],
    Cell[17845, 634, 97, 2, 32, "Subsubsection",
      CellTags->"OpenSpecial"],
    Cell[17945, 638, 491, 11, 84, "Notes",
      CellTags->"OpenSpecial"],
    Cell[18439, 651, 332, 13, 22, "Notes",
      CellTags->"OpenSpecial"]},
  "OpenSelection"->{
    Cell[18808, 669, 104, 2, 34, "Command",
      CellTags->"OpenSelection"],
    Cell[18915, 673, 188, 5, 29, "Usage",
      CellTags->"OpenSelection"],
    Cell[19106, 680, 388, 12, 36, "Notes",
      CellTags->"OpenSelection"],
    Cell[19497, 694, 771, 30, 36, "Notes",
      CellTags->"OpenSelection"],
    Cell[20271, 726, 275, 7, 36, "Notes",
      CellTags->"OpenSelection"]},
  "Import"->{
    Cell[20583, 738, 89, 2, 34, "Command",
      CellTags->"Import"],
    Cell[20675, 742, 192, 6, 29, "Usage",
      CellTags->"Import"]},
  "MenuListPalettesMenu"->{
    Cell[20904, 753, 105, 2, 34, "Command",
      CellTags->"MenuListPalettesMenu"],
    Cell[21012, 757, 162, 5, 29, "Usage",
      CellTags->"MenuListPalettesMenu"],
    Cell[21177, 764, 295, 8, 36, "Notes",
      CellTags->"MenuListPalettesMenu"],
    Cell[21475, 774, 242, 9, 22, "Notes",
      CellTags->"MenuListPalettesMenu"]},
  "MenuListNotebooksMenu"->{
    Cell[21754, 788, 107, 2, 34, "Command",
      CellTags->"MenuListNotebooksMenu"],
    Cell[21864, 792, 161, 5, 29, "Usage",
      CellTags->"MenuListNotebooksMenu"],
    Cell[22028, 799, 273, 7, 36, "Notes",
      CellTags->{"MenuListNotebooksMenu", "ModifyNotebooksMenu"}]},
  "ModifyNotebooksMenu"->{
    Cell[22028, 799, 273, 7, 36, "Notes",
      CellTags->{"MenuListNotebooksMenu", "ModifyNotebooksMenu"}]},
  "GeneratePalette"->{
    Cell[22338, 811, 123, 2, 34, "Command",
      CellTags->"GeneratePalette"],
    Cell[22464, 815, 191, 5, 29, "Usage",
      CellTags->"GeneratePalette"],
    Cell[22658, 822, 213, 5, 36, "Notes",
      CellTags->"GeneratePalette"]},
  "GenerateNotebook"->{
    Cell[22908, 832, 123, 2, 34, "Command",
      CellTags->"GenerateNotebook"],
    Cell[23034, 836, 202, 5, 29, "Usage",
      CellTags->"GenerateNotebook"]},
  "SystemPrintOptionsDialog"->{
    Cell[23312, 848, 114, 2, 34, "Command",
      CellTags->"SystemPrintOptionsDialog"],
    Cell[23429, 852, 257, 6, 43, "Usage",
      CellTags->"SystemPrintOptionsDialog"]},
  "PrintOptionsDialog"->{
    Cell[23723, 863, 114, 2, 34, "Command",
      CellTags->"PrintOptionsDialog"],
    Cell[23840, 867, 382, 11, 43, "Usage",
      CellTags->"PrintOptionsDialog"],
    Cell[24225, 880, 144, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[24372, 885, 138, 2, 20, "IndentedText",
      CellTags->"PrintOptionsDialog"],
    Cell[24513, 889, 149, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[24665, 894, 446, 11, 48, "IndentedText",
      CellTags->"PrintOptionsDialog"],
    Cell[25114, 907, 160, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[25277, 912, 298, 9, 34, "IndentedText",
      CellTags->"PrintOptionsDialog"],
    Cell[25578, 923, 132, 3, 25, "DialogItem",
      CellTags->"PrintOptionsDialog"],
    Cell[25713, 928, 262, 6, 34, "IndentedText",
      CellTags->"PrintOptionsDialog"]},
  "HeadersFootersDialog"->{
    Cell[26012, 939, 119, 2, 34, "Command",
      CellTags->"HeadersFootersDialog"],
    Cell[26134, 943, 203, 6, 29, "Usage",
      CellTags->"HeadersFootersDialog"],
    Cell[26352, 952, 239, 4, 36, "Notes",
      CellTags->"HeadersFootersDialog"],
    Cell[26594, 958, 274, 8, 36, "Notes",
      CellTags->"HeadersFootersDialog"],
    Cell[26871, 968, 79, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[26953, 971, 112, 1, 20, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[27068, 974, 81, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[27152, 977, 120, 2, 20, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[27275, 981, 81, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[27359, 984, 120, 2, 20, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[27482, 988, 78, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[27563, 991, 487, 9, 106, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[28053, 1002, 82, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[28138, 1005, 151, 4, 20, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[28292, 1011, 135, 6, 64, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[28430, 1019, 138, 4, 20, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[28571, 1025, 79, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[28653, 1028, 169, 4, 34, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[28825, 1034, 67, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[28895, 1037, 154, 4, 20, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[29052, 1043, 81, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[29136, 1046, 170, 4, 34, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[29309, 1052, 70, 1, 25, "DialogItem",
      CellTags->"HeadersFootersDialog"],
    Cell[29382, 1055, 162, 4, 20, "IndentedText",
      CellTags->"HeadersFootersDialog"],
    Cell[29547, 1061, 1330, 34, 194, "Notes",
      CellTags->"HeadersFootersDialog"]},
  "PrintDialog"->{
    Cell[30902, 1099, 54, 1, 34, "Command",
      CellTags->"PrintDialog"],
    Cell[30959, 1102, 142, 5, 29, "Usage",
      CellTags->"PrintDialog"],
    Cell[31104, 1109, 144, 3, 22, "Notes",
      CellTags->"PrintDialog"],
    Cell[31251, 1114, 295, 9, 36, "Notes",
      CellTags->"PrintDialog"],
    Cell[31549, 1125, 137, 3, 22, "Notes",
      CellTags->"PrintDialog"],
    Cell[31689, 1130, 314, 8, 50, "Notes",
      CellTags->"PrintDialog"],
    Cell[32006, 1140, 612, 19, 22, "Notes",
      CellTags->"PrintDialog"]},
  "PrintSelectionDialog"->{
    Cell[32655, 1164, 73, 1, 34, "Command",
      CellTags->"PrintSelectionDialog"],
    Cell[32731, 1167, 181, 5, 29, "Usage",
      CellTags->"PrintSelectionDialog"],
    Cell[32915, 1174, 281, 8, 36, "Notes",
      CellTags->"PrintSelectionDialog"],
    Cell[33211, 1185, 740, 21, 36, "Notes",
      CellTags->"PrintSelectionDialog"]},
  "FrontEndQuit"->{
    Cell[33976, 1210, 51, 1, 34, "Command",
      CellTags->"FrontEndQuit"],
    Cell[34030, 1213, 255, 10, 29, "Usage",
      CellTags->"FrontEndQuit"],
    Cell[34288, 1225, 275, 8, 36, "Notes",
      CellTags->"FrontEndQuit"],
    Cell[34566, 1235, 209, 6, 22, "Notes",
      CellTags->"FrontEndQuit"],
    Cell[34778, 1243, 584, 18, 22, "Notes",
      CellTags->"FrontEndQuit"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"New", 36193, 1288},
  {"Open", 36465, 1297},
  {"convertingFrom22NotebookDialogID", 37836, 1336},
  {"Close", 37955, 1339},
  {"Save", 38238, 1348},
  {"SaveRename", 38524, 1357},
  {"SaveRenameSpecial", 38844, 1366},
  {"SaveRenameSpecialNeXT", 39198, 1373},
  {"SaveRenameSpecialV20Notebook", 39559, 1380},
  {"convertingTo22NotebookDialogID", 39869, 1387},
  {"SaveRenameSpecialText", 40170, 1394},
  {"SaveRenameSpecialCellExpression", 40380, 1399},
  {"SaveRenameSpecialNotebookExpression", 40614, 1404},
  {"SaveRenameSpecialPackage", 40845, 1409},
  {"TeXSave", 41124, 1416},
  {"HTMLSave", 41352, 1423},
  {"OpenSpecial", 41586, 1430},
  {"OpenSelection", 43098, 1469},
  {"Import", 43497, 1480},
  {"MenuListPalettesMenu", 43665, 1485},
  {"MenuListNotebooksMenu", 44029, 1494},
  {"ModifyNotebooksMenu", 44336, 1501},
  {"GeneratePalette", 44469, 1504},
  {"GenerateNotebook", 44730, 1511},
  {"SystemPrintOptionsDialog", 44923, 1516},
  {"PrintOptionsDialog", 45126, 1521},
  {"HeadersFootersDialog", 46017, 1542},
  {"PrintDialog", 48242, 1593},
  {"PrintSelectionDialog", 48798, 1608},
  {"FrontEndQuit", 49157, 1617}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 41, 1, 34, "Command",
  CellTags->"New"],
Cell[1775, 54, 155, 6, 29, "Usage",
  CellTags->"New"],
Cell[1933, 62, 330, 11, 36, "Notes",
  CellTags->"New"],
Cell[2266, 75, 582, 18, 22, "Notes",
  CellTags->"New"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2885, 98, 73, 2, 34, "Command",
  CellTags->"Open"],
Cell[2961, 102, 186, 6, 29, "Usage",
  CellTags->"Open"],
Cell[3150, 110, 114, 2, 22, "Notes",
  CellTags->"Open"],
Cell[3267, 114, 324, 8, 80, "ItemizedText",
  CellTags->"Open"],
Cell[3594, 124, 257, 8, 22, "Notes",
  CellTags->"Open"],
Cell[3854, 134, 189, 6, 22, "Notes",
  CellTags->"Open"],
Cell[4046, 142, 529, 12, 70, "Notes",
  CellTags->{"convertingFrom22NotebookDialogID", "Open"}],
Cell[4578, 156, 583, 18, 22, "Notes",
  CellTags->"Open"],

Cell[CellGroupData[{
Cell[5186, 178, 178, 6, 32, "Subsubsection",
  CellTags->"Open"],
Cell[5367, 186, 131, 3, 22, "Notes",
  CellTags->"Open"],
Cell[5501, 191, 334, 7, 52, "NotesList",
  CellTags->"Open"],
Cell[5838, 200, 196, 6, 24, "NotesList"],
Cell[6037, 208, 148, 3, 22, "Notes",
  CellTags->"Open"],
Cell[6188, 213, 259, 6, 52, "NotesList",
  CellTags->"Open"],
Cell[6450, 221, 143, 3, 22, "Notes",
  CellTags->"Open"],
Cell[6596, 226, 190, 5, 38, "NotesList",
  CellTags->"Open"],
Cell[6789, 233, 131, 3, 22, "Notes",
  CellTags->"Open"],
Cell[6923, 238, 488, 11, 66, "NotesList",
  CellTags->"Open"],
Cell[7414, 251, 148, 3, 22, "Notes",
  CellTags->"Open"],
Cell[7565, 256, 117, 2, 24, "NotesList",
  CellTags->"Open"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7731, 264, 87, 2, 34, "Command",
  CellTags->"Close"],
Cell[7821, 268, 148, 5, 29, "Usage",
  CellTags->"Close"],
Cell[7972, 275, 265, 7, 36, "Notes",
  CellTags->"Close"],
Cell[8240, 284, 607, 19, 22, "Notes",
  CellTags->"Close"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8884, 308, 85, 2, 34, "Command",
  CellTags->"Save"],
Cell[8972, 312, 151, 5, 29, "Usage",
  CellTags->"Save"],
Cell[9126, 319, 356, 10, 50, "Notes",
  CellTags->"Save"]
}, Open  ]],
Cell[9497, 332, 605, 19, 22, "Notes",
  CellTags->"Save"],

Cell[CellGroupData[{
Cell[10127, 355, 97, 2, 34, "Command",
  CellTags->"SaveRename"],
Cell[10227, 359, 166, 5, 29, "Usage",
  CellTags->"SaveRename"],
Cell[10396, 366, 176, 5, 22, "Notes",
  CellTags->"SaveRename"],
Cell[10575, 373, 743, 22, 22, "Notes",
  CellTags->"SaveRename"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11355, 400, 139, 2, 34, "Command",
  CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],
Cell[11497, 404, 206, 5, 29, "Usage",
  CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],
Cell[11706, 411, 364, 10, 36, "Notes",
  CellTags->{"SaveRenameSpecial", "SaveRenameSpecialNeXT"}],

Cell[CellGroupData[{
Cell[12095, 425, 187, 4, 34, "Command",
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}],
Cell[12285, 431, 356, 11, 43, "Usage",
  CellTags->{
  "SaveRenameSpecialV20Notebook", "convertingTo22NotebookDialogID"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12678, 447, 129, 3, 34, "Command",
  CellTags->"SaveRenameSpecialText"],
Cell[12810, 452, 204, 6, 29, "Usage",
  CellTags->"SaveRenameSpecialText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13051, 463, 149, 3, 34, "Command",
  CellTags->"SaveRenameSpecialCellExpression"],
Cell[13203, 468, 277, 6, 43, "Usage",
  CellTags->"SaveRenameSpecialCellExpression"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13517, 479, 157, 3, 34, "Command",
  CellTags->"SaveRenameSpecialNotebookExpression"],
Cell[13677, 484, 288, 6, 43, "Usage",
  CellTags->"SaveRenameSpecialNotebookExpression"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14002, 495, 142, 3, 34, "Command",
  CellTags->"SaveRenameSpecialPackage"],
Cell[14147, 500, 324, 8, 43, "Usage",
  CellTags->"SaveRenameSpecialPackage"],
Cell[14474, 510, 178, 6, 22, "Notes",
  CellTags->"SaveRenameSpecialPackage"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14689, 521, 72, 2, 34, "Command",
  CellTags->"TeXSave"],
Cell[14764, 525, 187, 5, 29, "Usage",
  CellTags->"TeXSave"]
}, Open  ]],
Cell[14966, 533, 136, 3, 22, "Notes",
  CellTags->"TeXSave"],

Cell[CellGroupData[{
Cell[15127, 540, 74, 2, 34, "Command",
  CellTags->"HTMLSave"],
Cell[15204, 544, 190, 5, 29, "Usage",
  CellTags->"HTMLSave"]
}, Open  ]]
}, Open  ]],
Cell[15421, 553, 137, 3, 22, "Notes",
  CellTags->"HTMLSave"],

Cell[CellGroupData[{
Cell[15583, 560, 103, 2, 34, "Command",
  CellTags->"OpenSpecial"],
Cell[15689, 564, 335, 12, 43, "Usage",
  CellTags->"OpenSpecial"],
Cell[16027, 578, 157, 3, 22, "Text",
  CellTags->"OpenSpecial"],
Cell[16187, 583, 98, 2, 32, "Subsubsection",
  CellTags->"OpenSpecial"],
Cell[16288, 587, 116, 2, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[16407, 591, 263, 5, 48, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[16673, 598, 64, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[16740, 601, 84, 1, 20, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[16827, 604, 71, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[16901, 607, 100, 1, 20, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[17004, 610, 77, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[17084, 613, 98, 1, 20, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[17185, 616, 82, 1, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[17270, 619, 103, 1, 20, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[17376, 622, 108, 2, 25, "DialogItem",
  CellTags->"OpenSpecial"],
Cell[17487, 626, 355, 6, 62, "IndentedText",
  CellTags->"OpenSpecial"],
Cell[17845, 634, 97, 2, 32, "Subsubsection",
  CellTags->"OpenSpecial"],
Cell[17945, 638, 491, 11, 84, "Notes",
  CellTags->"OpenSpecial"],
Cell[18439, 651, 332, 13, 22, "Notes",
  CellTags->"OpenSpecial"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18808, 669, 104, 2, 34, "Command",
  CellTags->"OpenSelection"],
Cell[18915, 673, 188, 5, 29, "Usage",
  CellTags->"OpenSelection"],
Cell[19106, 680, 388, 12, 36, "Notes",
  CellTags->"OpenSelection"],
Cell[19497, 694, 771, 30, 36, "Notes",
  CellTags->"OpenSelection"],
Cell[20271, 726, 275, 7, 36, "Notes",
  CellTags->"OpenSelection"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20583, 738, 89, 2, 34, "Command",
  CellTags->"Import"],
Cell[20675, 742, 192, 6, 29, "Usage",
  CellTags->"Import"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20904, 753, 105, 2, 34, "Command",
  CellTags->"MenuListPalettesMenu"],
Cell[21012, 757, 162, 5, 29, "Usage",
  CellTags->"MenuListPalettesMenu"],
Cell[21177, 764, 295, 8, 36, "Notes",
  CellTags->"MenuListPalettesMenu"],
Cell[21475, 774, 242, 9, 22, "Notes",
  CellTags->"MenuListPalettesMenu"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21754, 788, 107, 2, 34, "Command",
  CellTags->"MenuListNotebooksMenu"],
Cell[21864, 792, 161, 5, 29, "Usage",
  CellTags->"MenuListNotebooksMenu"],
Cell[22028, 799, 273, 7, 36, "Notes",
  CellTags->{"MenuListNotebooksMenu", "ModifyNotebooksMenu"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22338, 811, 123, 2, 34, "Command",
  CellTags->"GeneratePalette"],
Cell[22464, 815, 191, 5, 29, "Usage",
  CellTags->"GeneratePalette"],
Cell[22658, 822, 213, 5, 36, "Notes",
  CellTags->"GeneratePalette"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22908, 832, 123, 2, 34, "Command",
  CellTags->"GenerateNotebook"],
Cell[23034, 836, 202, 5, 29, "Usage",
  CellTags->"GenerateNotebook"]
}, Open  ]],
Cell[23251, 844, 36, 0, 34, "Command"],

Cell[CellGroupData[{
Cell[23312, 848, 114, 2, 34, "Command",
  CellTags->"SystemPrintOptionsDialog"],
Cell[23429, 852, 257, 6, 43, "Usage",
  CellTags->"SystemPrintOptionsDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23723, 863, 114, 2, 34, "Command",
  CellTags->"PrintOptionsDialog"],
Cell[23840, 867, 382, 11, 43, "Usage",
  CellTags->"PrintOptionsDialog"],
Cell[24225, 880, 144, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[24372, 885, 138, 2, 20, "IndentedText",
  CellTags->"PrintOptionsDialog"],
Cell[24513, 889, 149, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[24665, 894, 446, 11, 48, "IndentedText",
  CellTags->"PrintOptionsDialog"],
Cell[25114, 907, 160, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[25277, 912, 298, 9, 34, "IndentedText",
  CellTags->"PrintOptionsDialog"],
Cell[25578, 923, 132, 3, 25, "DialogItem",
  CellTags->"PrintOptionsDialog"],
Cell[25713, 928, 262, 6, 34, "IndentedText",
  CellTags->"PrintOptionsDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26012, 939, 119, 2, 34, "Command",
  CellTags->"HeadersFootersDialog"],
Cell[26134, 943, 203, 6, 29, "Usage",
  CellTags->"HeadersFootersDialog"]
}, Open  ]],
Cell[26352, 952, 239, 4, 36, "Notes",
  CellTags->"HeadersFootersDialog"],
Cell[26594, 958, 274, 8, 36, "Notes",
  CellTags->"HeadersFootersDialog"],
Cell[26871, 968, 79, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[26953, 971, 112, 1, 20, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[27068, 974, 81, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[27152, 977, 120, 2, 20, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[27275, 981, 81, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[27359, 984, 120, 2, 20, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[27482, 988, 78, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[27563, 991, 487, 9, 106, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[28053, 1002, 82, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[28138, 1005, 151, 4, 20, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[28292, 1011, 135, 6, 64, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[28430, 1019, 138, 4, 20, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[28571, 1025, 79, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[28653, 1028, 169, 4, 34, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[28825, 1034, 67, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[28895, 1037, 154, 4, 20, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[29052, 1043, 81, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[29136, 1046, 170, 4, 34, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[29309, 1052, 70, 1, 25, "DialogItem",
  CellTags->"HeadersFootersDialog"],
Cell[29382, 1055, 162, 4, 20, "IndentedText",
  CellTags->"HeadersFootersDialog"],
Cell[29547, 1061, 1330, 34, 194, "Notes",
  CellTags->"HeadersFootersDialog"],

Cell[CellGroupData[{
Cell[30902, 1099, 54, 1, 34, "Command",
  CellTags->"PrintDialog"],
Cell[30959, 1102, 142, 5, 29, "Usage",
  CellTags->"PrintDialog"],
Cell[31104, 1109, 144, 3, 22, "Notes",
  CellTags->"PrintDialog"],
Cell[31251, 1114, 295, 9, 36, "Notes",
  CellTags->"PrintDialog"],
Cell[31549, 1125, 137, 3, 22, "Notes",
  CellTags->"PrintDialog"],
Cell[31689, 1130, 314, 8, 50, "Notes",
  CellTags->"PrintDialog"],
Cell[32006, 1140, 612, 19, 22, "Notes",
  CellTags->"PrintDialog"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32655, 1164, 73, 1, 34, "Command",
  CellTags->"PrintSelectionDialog"],
Cell[32731, 1167, 181, 5, 29, "Usage",
  CellTags->"PrintSelectionDialog"],
Cell[32915, 1174, 281, 8, 36, "Notes",
  CellTags->"PrintSelectionDialog"]
}, Open  ]],
Cell[33211, 1185, 740, 21, 36, "Notes",
  CellTags->"PrintSelectionDialog"],

Cell[CellGroupData[{
Cell[33976, 1210, 51, 1, 34, "Command",
  CellTags->"FrontEndQuit"],
Cell[34030, 1213, 255, 10, 29, "Usage",
  CellTags->"FrontEndQuit"],
Cell[34288, 1225, 275, 8, 36, "Notes",
  CellTags->"FrontEndQuit"],
Cell[34566, 1235, 209, 6, 22, "Notes",
  CellTags->"FrontEndQuit"],
Cell[34778, 1243, 584, 18, 22, "Notes",
  CellTags->"FrontEndQuit"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

